////////////////////////////////////////////////////////
// File Name: SignatureValidation.cpp
//
//  Abstract: Implements signature validation class.
//
////////////////////////////////////////////////////////

#include "stdafx.h"
#include "SignatureValidation.h"

/////////////////////////////////////////////////////////////////////////////
// Function       : NormalizePath
// Description    : Makes a path 'normal' for comparisons.
// Return type    : CATLString - The normalized path.
// Argument [In]  : const CATLString& Path - The path.
/////////////////////////////////////////////////////////////////////////////
CATLString NormalizePath(const CATLString& Path)
{
	CATLString RetVal = Path;
	RetVal.Trim();
	RetVal.MakeLower();

	RetVal.Replace(AltDirectorySeparatorChar, DirectorySeparatorChar);

	return RetVal;
}