////////////////////////////////////////////////////////
// File Name: CompressedFileImp.cpp
//
//  Abstract: Implements CCompressedFileCollection and CCompressedFile abstract classes.
//
////////////////////////////////////////////////////////

#include "stdafx.h"
#include "CompressedFileImp.h"

bool CCompressedFileCollectionImp::ReadCompressedFile(CATLString File, CCompressedFileCollectionImp*& pCompressedFiles)
{
	bool RetVal = false;
	CompressedFileCollectionSharedPtr spCompressedFiles;

	if(C7zipCompressedFileCollection::ReadCompressedFile(File, spCompressedFiles))
	{
		pCompressedFiles = new CCompressedFileCollectionImp(spCompressedFiles);
		RetVal = true;
	}

	return RetVal;
}

ULONG CCompressedFileCollectionImp::Release()
{
	ULONG NewRef = --m_RefCount;

	if(NewRef == 0)
	{
		delete this;
	}

	return NewRef;
}

int CCompressedFileCollectionImp::GetCount()
{
	return m_spCompressedFiles->GetCount();
}

CCompressedFile* CCompressedFileCollectionImp::GetCompressedFile(int Index)
{
	return new CCompressedFileImp(m_spCompressedFiles->GetCompressedFile(Index));
}

ULONG CCompressedFileImp::Release()
{
	ULONG NewRef = --m_RefCount;

	if(NewRef == 0)
	{
		delete this;
	}

	return NewRef;
}

BSTR CCompressedFileImp::GetFileName()
{
	CATLString RetVal(m_spCompressedFile->GetFileName());

	return RetVal.AllocSysString();
}

__int64 CCompressedFileImp::GetFileSize()
{
	return m_spCompressedFile->GetFileSize();
}

VARIANT_BOOL CCompressedFileImp::Extract(BSTR OutputFileName)
{
	VARIANT_BOOL RetVal = VARIANT_FALSE;

	if(m_spCompressedFile->Extract(CATLString(OutputFileName)))
	{
		RetVal = VARIANT_TRUE;
	}

	return RetVal;
}
