////////////////////////////////////////////////////////
// File Name: FileExtractor.h
//
//  Abstract: Extracts compressed files.
//
////////////////////////////////////////////////////////

#ifndef __FILEEXTRACTOR_H_
#define __FILEEXTRACTOR_H_

#include "tchar.h"
#include "windows.h"

class C7zipCompressedFile;

typedef shared_ptr<C7zipCompressedFile> CompressedFileSharedPtr;
typedef vector<CompressedFileSharedPtr> CompressedFileSharedPtrVector;

class C7zipCompressedFileCollection;
typedef shared_ptr<C7zipCompressedFileCollection> CompressedFileCollectionSharedPtr;

class C7zipCompressedFileCollection
{
public:
	struct SCompressedFileHandle;
	typedef shared_ptr<SCompressedFileHandle> CompressedFileHandleSharedPtr;
	static CompressedFileCollectionSharedPtr CreateInstance(CompressedFileHandleSharedPtr spFileHandle);
	static bool ReadCompressedFile(LPCWSTR File, CompressedFileCollectionSharedPtr& spCompressedFiles);

	CompressedFileSharedPtr GetCompressedFile (int Index) const { return m_CompressedFiles.at(Index); }
	int GetCount() { return m_CompressedFiles.size(); }

	void Clear() { m_CompressedFiles.clear(); }

private:
	C7zipCompressedFileCollection() {}
	C7zipCompressedFileCollection(const C7zipCompressedFileCollection& ToCopy);
	C7zipCompressedFileCollection& operator=(const C7zipCompressedFileCollection& ToCopy);

	CompressedFileHandleSharedPtr m_spFileHandle;
	CompressedFileSharedPtrVector m_CompressedFiles;
};

class C7zipCompressedFile
{
public:
	static CompressedFileSharedPtr CreateInstance(C7zipCompressedFileCollection::CompressedFileHandleSharedPtr spFileHandle, int FileIndex);
	CATLString GetFileName();
	unsigned __int64 GetFileSize();
	bool Extract(LPCTSTR OutputFileName);
private:
	C7zipCompressedFile() : m_FileIndex(-1) {}
	C7zipCompressedFile(const C7zipCompressedFile& ToCopy);
	C7zipCompressedFile& operator=(const C7zipCompressedFile& ToCopy);

	C7zipCompressedFileCollection::CompressedFileHandleSharedPtr m_spFileHandle;
	int m_FileIndex;
};

#endif
