////////////////////////////////////////////////////////
// File Name: ArchiveExtractCallback.h
//
//  Abstract: Callback for when 7 zip extracts a compressed file.
//
////////////////////////////////////////////////////////

#pragma once

struct IInArchive;
struct CArc;

namespace SevenZipExtractor
{
class CArchiveExtractCallback : public IArchiveExtractCallback, public CMyUnknownImp
{
public:
    CArchiveExtractCallback(const CArc *arc, const CATLString& OutputFilePath);

// IUnknown
    MY_UNKNOWN_IMP1(IArchiveExtractCallback);

// IProgress
    STDMETHOD(SetTotal)(UInt64 size);
    STDMETHOD(SetCompleted)(const UInt64 *pCompleteValue);

// IArchiveExtractCallback
    STDMETHOD(GetStream)(UInt32 index, ISequentialOutStream **ppOutStream, Int32 askExtractMode);
    STDMETHOD(PrepareOperation)(Int32 askExtractMode);
    STDMETHOD(SetOperationResult)(Int32 result);

private:
    const CArc *m_arc;
    UInt64 m_totalBytes;
	CATLString m_OutputFilePath;
};
}
