////////////////////////////////////////////////////////
// File Name: CompressionManager.h
//
//  Abstract: Interface methods to expose viewing and extracting archives.  The file needs to be
//			referenced in the calling code.
//
////////////////////////////////////////////////////////

#if !defined(AFX_COMPRESSIONMANAGER_H__24B730C3_AA62_11D2_A66B_00105A1CF3A4__INCLUDED_)
#define AFX_COMPRESSIONMANAGER_H__24B730C3_AA62_11D2_A66B_00105A1CF3A4__INCLUDED_

//////////////ERROR CODES/////////////////////////////////
const int READCOMPRESSEDFILE_SUCCESS = 0;
const int READCOMPRESSEDFILE_ERROR = -1;

const int WRITECOMPRESSEDFILE_SUCCESS = 0;
const int WRITECOMPRESSEDFILE_ERROR = -1;
const int WRITECOMPRESSEDFILE_ERROR_CREATE = -2;
const int WRITECOMPRESSEDFILE_ERROR_UPDATE = -3;
const int WRITECOMPRESSEDFILE_ERROR_FORMAT = -4;
const int WRITECOMPRESSEDFILE_ERROR_READING_FILE = -5;
//////////////ERROR CODES/////////////////////////////////

/////////////////////////////////////////////////////////////////////////////
// Function       : enum CompressionFormat
// Description    : An enum of the currently supported archive formats
/////////////////////////////////////////////////////////////////////////////
enum CompressionFormat {Zip, SevenZip};

struct CCompressedFile
{
	virtual ULONG Release() = 0;
	virtual BSTR GetFileName() = 0;
	virtual __int64 GetFileSize() = 0;
	virtual VARIANT_BOOL Extract(BSTR OutputFileName) = 0;
};

struct CCompressedFileCollection
{
	virtual ULONG Release() = 0;
	virtual int GetCount() = 0;
	virtual CCompressedFile* GetCompressedFile(int Index) = 0;
};

struct CArchiveWriter
{
	// **** To create a compressed archive using CArchiveWriter: ****
	// 1. Use CreateArchiveWriter to get a new ArchiveWriter
	// 2. Use AddFile to add files to the archive
	// 3. Call SaveArchive with a path and a CompressionFormat to write the archive to disk
	
	/////////////////////////////////////////////////////////////////////////////
	// Function       : CArchiveWriter::AddFile
	// Description    : Adds a file to the ArchiveWriter.  Use WriteArchive to 
	//                  actually write the archive file to disk after you've added
	//                  all your files.
	// Return type    : void
	// Argument       : BSTR sourcePath - the path to the file to add
	// Argument       : BSTR destinationPath - the path that the file should 
	//                  have in the archive
	/////////////////////////////////////////////////////////////////////////////
	virtual int AddFile(BSTR sourcePath, BSTR destinationPath) = 0;

	/////////////////////////////////////////////////////////////////////////////
	// Function       : CArchiveWriterImp::SaveArchive
	// Description    : Creates an archive of the previously specified files and 
	//                  format
	// Return type    : int - error code
	// Argument       : BSTR archivePath - archive will be created at this 
	//                  path
	// Argument       : CompressionFormat format - the format you want to use
	/////////////////////////////////////////////////////////////////////////////
	virtual int SaveArchive(BSTR archivePath, CompressionFormat format) = 0;
	
	virtual ULONG Release() = 0;
};

typedef int (__cdecl *LPRREADCOMPRESSEDFILE)(BSTR, CCompressedFileCollection**);
typedef int (__cdecl *LPRFUNC2)(CCompressedFileCollection*, BSTR, BSTR);
typedef int (__cdecl *LPRCREATEARCHIVEWRITER)(CArchiveWriter**);

/////////////////////////////////////////////////////////////////////////////
// Function       : ReadCompressedFile
// Description    : Loads a compressed file.
// Return type    : int - A value indicating success or failure as defined above.
// Argument [In]  : BSTR CompressedFile - The hard drive path to the file.
// Argument [Out] : CCompressedFileCollection** ppCompressedFileCollection - The files in the compressed file.
/////////////////////////////////////////////////////////////////////////////
extern "C" int __declspec( dllexport ) __cdecl ReadCompressedFile(BSTR CompressedFile, CCompressedFileCollection** ppCompressedFileCollection);

/////////////////////////////////////////////////////////////////////////////
// Function       : Func2
// Description    : Verifies the signature on a file.  The name is intentionally made Func2.
// Return type    : int - S_OK for success, E_FAIL for failure.
// Argument [In]  : CCompressedFileCollection* pCompressedFileCollection - The zip file containing the files to validate.
// Argument [In]  : BSTR ManifestFile - The full path to the file to check.
// Argument [In]  : BSTR WorkingFolderPath - The path where this function can extract temporary files to.
/////////////////////////////////////////////////////////////////////////////
extern "C" int __declspec( dllexport ) __cdecl Func2(CCompressedFileCollection* pCompressedFileCollection, BSTR ManifestFile, BSTR WorkingFolderPath);

/////////////////////////////////////////////////////////////////////////////
// Function       : int __declspec
// Description    : Creates a new ArchiveWriter
// Return type    : int - 0 if success
// Argument [Out] : CArchiveWriter** ppArchiveHandle - the ArchiveWriter
/////////////////////////////////////////////////////////////////////////////
extern "C" int __declspec( dllexport ) __cdecl CreateArchiveWriter(CArchiveWriter** ppArchiveWriterHandle);
#endif
