////////////////////////////////////////////////////////
// File Name: ArchiveWriterImp.h
//
//  Abstract: Implements the CArchiveWriter abstract class
//
////////////////////////////////////////////////////////

#pragma once

#include "CompressionManager.h"

class CCodecs;

class CArchiveWriterImp : public CArchiveWriter
{
public:
	virtual ~CArchiveWriterImp() {}

	// factory constructor
	static int CreateArchiveWriter(CArchiveWriter*& pArchiveHandle);

	virtual int AddFile(BSTR sourcePath, BSTR destinationPath);
	virtual int SaveArchive(BSTR archivePath, CompressionFormat format);
	virtual ULONG CArchiveWriterImp::Release();

private:
	CArchiveWriterImp();

	static int GetFormatFromEnum(CompressionFormat format);

	vector<pair<CATLString, CATLString>> m_Files;
	
	static bool LoadDll(void);
	int m_RefCount;
};