////////////////////////////////////////////////////////
// File Name: CompressedFileImp.h
//
//  Abstract: Implements CCompressedFileCollection and CCompressedFile abstract classes.
//
////////////////////////////////////////////////////////

#if !defined(AFX_COMPRESSEDFILEIMP_H__24B730C3_AA62_11D2_A66B_00105A1CF3A4__INCLUDED_)
#define AFX_COMPRESSEDFILEIMP_H__24B730C3_AA62_11D2_A66B_00105A1CF3A4__INCLUDED_

#include "CompressionManager.h"
#include "FileExtractor.h"

class CCompressedFileImp : public CCompressedFile
{
public:
	CCompressedFileImp(CompressedFileSharedPtr spCompressedFile) : m_RefCount(1), m_spCompressedFile(spCompressedFile) {}
	virtual ~CCompressedFileImp() {}

	virtual ULONG Release();
	virtual BSTR GetFileName();
	virtual __int64 GetFileSize();
	virtual VARIANT_BOOL Extract(BSTR OutputFileName);
private:
	CompressedFileSharedPtr m_spCompressedFile;
	int m_RefCount;
};

class CCompressedFileCollectionImp : public CCompressedFileCollection
{
public:
	static bool ReadCompressedFile(CATLString File, CCompressedFileCollectionImp*& pCompressedFiles);

	virtual ~CCompressedFileCollectionImp() {}

	virtual ULONG Release();
	virtual int GetCount();
	virtual CCompressedFile* GetCompressedFile(int Index);
private:
	CCompressedFileCollectionImp(CompressedFileCollectionSharedPtr spCompressedFiles) : m_RefCount(1), m_spCompressedFiles(spCompressedFiles) {}

	CompressedFileCollectionSharedPtr m_spCompressedFiles;
	int m_RefCount;
};

#endif
