////////////////////////////////////////////////////////
// File Name: CompressionManager.cpp
//
//  Abstract: Interface methods to expose viewing and extracting archives.
//
////////////////////////////////////////////////////////

#include "stdafx.h"
#include "CompressionManager.h"
#include "CompressedFileImp.h"
#include "ArchiveWriterImp.h"
#include "XMLSignatureVerifier.h"
#include "SignatureValidation.h"

extern "C" int __declspec( dllexport ) __cdecl ReadCompressedFile(BSTR CompressedFile, CCompressedFileCollection** ppCompressedFileCollection)
{
	int RetVal = READCOMPRESSEDFILE_ERROR;
	CATLString File(CompressedFile);
	CCompressedFileCollectionImp* pCompressedFiles;

	if(ppCompressedFileCollection != nullptr)
	{
		if(CCompressedFileCollectionImp::ReadCompressedFile(CompressedFile, pCompressedFiles))
		{
			RetVal = READCOMPRESSEDFILE_SUCCESS;
			*ppCompressedFileCollection = pCompressedFiles;
		}
	}

	return RetVal;
}

extern "C" int __declspec( dllexport ) __cdecl Func2(CCompressedFileCollection* pCompressedFileCollection, BSTR ManifestFile, BSTR WorkingFolderPath)
{
	int RetVal = E_FAIL;

	CXMLSignatureVerifier Verifier;
	CATLString WorkingFolder(WorkingFolderPath);
	CATLString Manifest(ManifestFile);

	shared_ptr<CSignatureValidation> spValidationFunctions(new CSignatureValidation(pCompressedFileCollection, CATLString(WorkingFolder)));

	if(Verifier.Initialize())
	{
		Verifier.SetXMLSignatureCallback(spValidationFunctions);

		if(Verifier.ValidateFile(Manifest))
		{
			RetVal = S_OK;
		}
	}

	return RetVal;
}

extern "C" int __declspec( dllexport ) __cdecl CreateArchiveWriter(CArchiveWriter** ppArchiveHandle)
{
	int RetVal = WRITECOMPRESSEDFILE_ERROR;
	CArchiveWriter* pArchiveHandle;


	if(CArchiveWriterImp::CreateArchiveWriter(pArchiveHandle) == WRITECOMPRESSEDFILE_SUCCESS)
	{
		RetVal = WRITECOMPRESSEDFILE_SUCCESS;
		*ppArchiveHandle = pArchiveHandle;
	}

	return RetVal;
}