/*$Header:  /Utilities/CompressionManager/OIPCompressionManager/include/XMLSignatureVerifier.h v30934  04/24/2013 12:22:40 PM BrendKM $*/
////////////////////////////////////////////////////////
//
// Copyright 2011 Caterpillar Inc.  All Rights Reserved.
// This work contains Caterpillar's proprietary 
// information which may constitute a trade secret
// secret and/or be confidential.  Copyright notice 
// is precautionary only and does not imply publication.
//
//     Class: CXMLSignatureVerifier
//
// File Name: XMLSignatureVerifier.h
//
//  Abstract: Verifies the integrity of an XML signature.
//
////////////////////////////////////////////////////////
 
#if !defined(AFX_XMLSIGNATUREVERIFIER_H__CAB8DC75_686F_11D4_A8CE_00105A1CF3A4__INCLUDED_)
#define AFX_XMLSIGNATUREVERIFIER_H__CAB8DC75_686F_11D4_A8CE_00105A1CF3A4__INCLUDED_

class CXMLSignatureCallback;
typedef shared_ptr<CXMLSignatureCallback> XMLSignatureCallbackSharedPtr;

class CXMLSecCallbacks;

class CXMLSignatureCallback
{
public:
	virtual ~CXMLSignatureCallback() {}

	virtual bool XMLFileMatch(const CATLString& FileName) = 0;
	virtual bool XMLFileOpen(const CATLString& FileName, HANDLE& pFileHandle) = 0;
	virtual bool XMLFileRead(HANDLE FileHandle, BYTE* pbuffer, int Length, DWORD& BytesRead) = 0;
	virtual bool CustomxmlFileClose(HANDLE FileHandle) = 0;
};

class CXMLSignatureVerifier
{
	friend class CXMLSecCallbacks;
public:
	CXMLSignatureVerifier();
	virtual ~CXMLSignatureVerifier();

	bool Initialize();
	bool ValidateFile(const CATLString& XMLFile);
	bool ValidateObjectNodes(const CATLString& XMLFile);
	void SetXMLSignatureCallback(XMLSignatureCallbackSharedPtr spCallback);
	void ResetCallback();
private:

	struct SXMLHiddenVariables;
	typedef shared_ptr<SXMLHiddenVariables> XMLHiddenVariablesSharedPtr;
	XMLHiddenVariablesSharedPtr m_spVariables;

	bool m_Initialized;
	XMLSignatureCallbackSharedPtr m_spCallback;
};

#endif // !defined(AFX_XMLSIGNATUREVERIFIER_H__CAB8DC75_686F_11D4_A8CE_00105A1CF3A4__INCLUDED_)
